﻿// See https://aka.ms/new-console-template for more information
/*The digital Realms of C# have playing cards like ours but with some differences. Each card has a color 
   (red, green, blue, yellow) and a rank (the numbers 1 through 10, followed by the symbols $, %, ^, and &). 
   The third pedestal requires that you create a class to represent a card of this nature.
   */



Console.Title = "The Card";
Console.BackgroundColor = ConsoleColor.Black;
Console.ForegroundColor = ConsoleColor.DarkCyan;
Console.Beep();


Deck.ShowDeck();


public class Card
{
   public CardColor CardColor { get; }
   public CardRank CardRank { get; }

   public Card(CardColor cardColor, CardRank cardRank)
   {
      this.CardColor = cardColor;
      this.CardRank = cardRank;
   }
   
   public void ShowCard()
   {
      Console.WriteLine($"The {CardRank} of {CardColor}");
   }
}

public class Deck
{
   public static void ShowDeck()
   {
      foreach (CardColor color in Enum.GetValues(typeof(CardColor)))
      {
         foreach (CardRank rank in Enum.GetValues(typeof(CardRank)))
         {
            switch (color)
            {
               case CardColor.Diamonds:
                  Console.ForegroundColor = ConsoleColor.Red;
                  break;
               case CardColor.Spades:
                  Console.ForegroundColor = ConsoleColor.Blue;
                  break;
               case CardColor.Hearts:
                  Console.ForegroundColor = ConsoleColor.Red;
                  break;
               case CardColor.Clubs:
                  Console.ForegroundColor = ConsoleColor.Blue;
                  break;
            }
            Card card = new Card(color, rank);
            card.ShowCard();

         }
         
      }
   }
}

public enum CardColor {Diamonds, Spades, Hearts, Clubs}
public enum CardRank
{
   Ace = 1,    // Ace is represented as 1
   Two ,
   Three ,
   Four ,
   Five ,
   Six ,
   Seven ,
   Eight ,
   Nine ,
   Ten,
   Jack, 
   Queen, 
   King 
}
